import { prepareDesignEditor, addToDesign } from "https://sdk.canva.com/design/v1.js";

const EMBED_URL = "https://mvp.arsbook.it/viewer2/embed.html";
const THUMB_URL = "https://mvp.arsbook.it/viewer2/thumbnail.png";

prepareDesignEditor({
  render: async () => {
    // UI minimale: un solo pulsante per inserire l'embed
    document.body.innerHTML = "";
    const btn = document.createElement("button");
    btn.textContent = "Inserisci viewer 3D";
    btn.style.cssText = "padding:12px 16px;border:0;border-radius:6px;background:#0d6efd;color:#fff;font-weight:600;cursor:pointer;";

    btn.onclick = async () => {
      await addToDesign({
        type: "EMBED",
        url: EMBED_URL,
        title: "MVPARS 3D Viewer",
        thumbnailUrl: THUMB_URL,
        provider: "MVPARS"
      });
    };

    document.body.appendChild(btn);
  },
});
